function [nvert,filename,dir2,filenameord] = stitch_vertprop(varargin)
%little function to stitch back a vertices file from a vert and prop file
%Synatax:   [nvert] = stitch_vertprop('dir1','c:\...','file1',..,dir2)
%Input:     'dir1' = the directory the the selected channel, e.g., the
%                channel that is used to define the new subclass
%           'file1' = the file that contains the vertices of the channel
%               that is generated by savpivots that will be used to
%               regenerate a vertices file, ala find_centroid
%           'dir2' = the directory saved to.
%           'propstr' = the string name of the prop file so either: aprop,
%               or prop, or something else all together. Default = prop
%           note: if nothing is entered, you will be prompted to select
%           dir1, dir2, dir3.
%           'filelabel' = the label for the files, strings attached to the
%               beginning of the file, default = x
%Output:    nvert = the new vertices file.
%           filename = the filename of the vertices file with no ordinals
%           filepath = the directory where that file is saved
%           filenameord = the filename of the vertices file with ordinals

[dir1,file1,dir2,filelabel,propstr] = parse(varargin);

vert = single(dlmread([dir1,file1],',',1,0));    %open the file
%now open the properties files for these vertices, this is all in the
%environment setup by the savpivots
dir_info = dir(dir1);   %grab the file info from dir2
%pull out the channel name
%stridx = file1=='_';
stridx = isstrprop(file1,'punct');
stridx = find(stridx==1);   %the second '_' is the one
propfile = pullfile(dir_info,file1(stridx(1)+1:stridx(2)-1),propstr);   %pull the file
%open the prop file
prop = single(dlmread([dir1,propfile],',',1,0));
%grab the string for the directory
dirstridx = dir1==filesep;
dirstridx = find(dirstridx==1);
dirstr = dir1(dirstridx(end-1)+1:end-1);   %the directory string
%stitich back a vertices file
nvert = [vert(:,1:3),prop(:,1:end-1)];  %all props except for last column which is distance to ori, not in original
if size(vert,2)>3   %the origin verts
    nvert = [nvert,vert(:,4:end)];    %append the ordinals
    %save out a new file
    sav2csv(nvert,[filelabel,'vert_',dirstr,'_',file1(stridx(1)+1:end-4)],dir2);     %save the a file with the ordinals
    filenameord = [filelabel,'vert_',dirstr,'_',file1(stridx(1)+1:end-4),'.csv'];
else
    filenameord = [];
end
%save the vertices file - no ordinals
sav2csv(nvert(:,1:3+size(prop,2)-1),[filelabel,dirstr,' ',file1(stridx(1)+1:end-4)],dir2);
filename = [filelabel,dirstr,' ',file1(stridx(1)+1:end-4),'.csv'];

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [dir1,file1,dir2,filelabel,propstr] = parse(input)

dir1 = [];
dir2 = [];      
file1 = [];
filelabel = 'x';    %defaults
propstr = 'prop';

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dir1'
                    dir1 = input{1,i+1};
                case 'file1'
                    file1 = input{1,i+1};
                case 'dir2'
                    dir2 = input{1,i+1};
                case 'filelabel'
                    filelabel = input{1,i+1};
                case 'propstr'
                    propstr = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

if isempty(dir1)||isempty(file1)    %no directory or vertices file entered
    [file1,dir1,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open the vertices file','Multiselect','off');
else    %check if the entered dir1 has filesep
    if find(dir1==filesep==1,1,'last')~=size(dir1,2)    %no filesep at the end
        dir1 = [dir1 filesep];      %add filesep
    end
end

if isempty(dir2)
    dir2 = uigetdir3('','Directory to save the data of new subclass');
end

%--------------------------------------------------------------------------
%subfunction pull properties file
function [filename] = pullfile(dir_struct,matchstr,propstr)

for i = 3:size(dir_struct,1)    %go through the 
    idx(i-2) = dir_struct(i).isdir;     %pull the isdir info
    names{i-2} = dir_struct(i).name;     %pull the file and dir names
end

%get the files
list = names(~idx);

for j = 1:size(list,2);
    %the only files we care about are the flat rotated vertices and the properties for now
    stridx = isstrprop(list{j},'punct');
    stridx = find(stridx==1);   %the second '_' is the one
    if strcmp(propstr,list{j}(1:stridx(1)-1)) %first step
        if strcmp(list{j}(stridx(1)+1:stridx(2)-1),matchstr)    %the match we are looking for
            filename = list{j};
        end
    end
end